package idempiere.lab.plugin.model;

import org.compiere.model.MBPartner;
import org.compiere.model.MClient;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;

public class BPartnerValidator implements ModelValidator {

	@Override
	public void initialize(ModelValidationEngine engine, MClient client) {
		engine.addModelChange(MBPartner.Table_Name, this);
		if (client != null)
			AD_Client_ID = client.getAD_Client_ID();

	}

	private int AD_Client_ID;

	@Override
	public int getAD_Client_ID() {
		return AD_Client_ID;
	}

	@Override
	public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
		return null;
	}

	@Override
	public String modelChange(PO po, int type) throws Exception {
		if (po instanceof MBPartner)
		{
			if(type == TYPE_BEFORE_NEW)
			{
				//MBPartner bp = (MBPartner) po;
				Integer C_Corporation_ID = (Integer) po.get_Value("C_Corporation_ID");
				if(C_Corporation_ID == null || C_Corporation_ID.intValue() == 0)
				{
					return "法人マスタを入力して下さい";
				}

			}

		}
		return null;
	}

	@Override
	public String docValidate(PO po, int timing) {
		// TODO 自動生成されたメソッド・スタブ
		return null;
	}

}
